package CommissionCalculatorApp;

/**
 *
 * //author Adam Lee Patrick
 * //date April 17,2017
 * //professor Michael Flanagan
 * //class PRG 420
 */

public class SalesPerson {
    
/*
 * This class calculate the annual compensation of the sales person.
 */

    //Private Variables of the salesPerson class
    private double fixedSalary = 12000;
    private double salesTarget = 120000;
    private float minimumSales = 0.80f;
    private double commissionRate = 0.07;
    private float accelerationFactor = .0125f;

    public double compensation(double annualSales) {
        //Calculate the total annual compensation.

        double minSalesCalc = salesTarget * minimumSales; //Calculate minuimum sales required for Commission.

        int differ = Double.compare(annualSales, minSalesCalc);
        // if the differ variable is negative, the annualSales is considered smaller than the minSalesCalc
        // if the differ variable is positive, the annualSales is considered larger than the minSalesCalc
        // if the differ variable is 0, the values are considered to be equal.

        if (differ >= 0) {// Check Sale person exceeds 80% of sales target or not
            minSalesCalc = fixedSalary;
            if (annualSales > salesTarget) { // Check Sale person exceeds of sales target or not 
                minSalesCalc += annualSales * commissionRate;
                minSalesCalc += (annualSales - salesTarget) * accelerationFactor;// add acceleration factor of 1.25%
            } else {
                minSalesCalc += annualSales * commissionRate;
            }
            return Math.round(minSalesCalc);
        } else {
            return fixedSalary;
        }
    }
}


